require 'socket'

PORT = 27341
$socket = TCPServer.new('0.0.0.0', PORT)
$originalword = ""

class LetterSub
  @@dictinput = File.new("/root/LetterSub/dictionary", "r");
  @@dictarray = Array.new();
  @@upperalph = ["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"]
  @@loweralph = ["a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"]

  @@index = 0

  @@numguesses = 0
  @@numwords = 0
  @@numcorrect = 0
  
  def start
    x = 0
    #@@dictinput[@@index] = nil
    while x < 236006
      @@dictarray[x] = @@dictinput.readline
      #puts @@dictarray[x]
      x = x + 1
    end
    selectRandLine
  end

  def selectRandLine
    n = rand(236006)
    selection = @@dictarray[n]
    for z in 0..(@@dictarray[n].length - 1)
      $originalword[z] = @@dictarray[n][z]
    end
    selectRandLetter(selection)
  end

  def selectRandLetter(word)
    c = rand(word.length - 1)
    swapLetters(c, word)
  end

  def swapLetters(letterindex, word)
    casesense = rand(2)
    newletter = nil
    if casesense == 0 or ((casesense == 1) && (letterindex != 0)) then
      newletter = @@loweralph[rand(26)]
      while (newletter == word[letterindex])
        newletter = @@loweralph[rand(26)]
      end
    else
      if letterindex == 0 then
        newletter = @@upperalph[rand(26)]
        while (newletter == word[letterindex])
          newletter = @@upperalph[rand(26)]
        end
      end
    end
    
    word[letterindex] = newletter
    puts word + "\n"
    @@numwords = @@numwords + 1
    takeTurn(newletter)
    #printWord
  end

  def takeTurn(newletter)
    print "Which letter has been substituted? "
    input = gets
    input = input.chomp
    @@numguesses = @@numguesses + 1

    if input == newletter then
      puts "You got it! " + $originalword
      @@numcorrect = @@numcorrect + 1
      print "Would you like another word? (y/n) "
      selection = gets.chomp
      if selection == "y" then
          $originalword = ""
          @@index = 0
          selectRandLine
      else
        puts "Correct: " + @@numcorrect.to_s
        puts "Guesses: " + @@numguesses.to_s
        percent = (@@numcorrect.to_f / @@numguesses.to_f)
        puts "Percent: " + (percent * 100).to_s + "%\n"
        puts "Score: " + (@@numwords.to_f + (@@numwords.to_f * percent)).to_s
          exit
      end
    else
      puts "Incorrect \n"
      takeTurn(newletter) 
    end
  end

  def printWord
    #for s in 0..@@dictarray[@@dictarray.length - 1]
      #for t in 0..@@dictarray[@@dictarray.length - 1]
        #puts @@dictarray[@@index]
      #end
    #end
  end
end
